<?php if(isset($offer)): ?>
    <?php $__env->startSection('title', 'Edit Offer'); ?>
<?php else: ?>
<?php $__env->startSection('title', 'Create Offer'); ?>
<?php endif; ?>

<?php $__env->startPush('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/css/tom-select.bootstrap5.min.css" rel="stylesheet">
<link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<link rel="stylesheet" href="<?php echo e(asset('backend/summernote/summernote-lite.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="container-xl">
    <!-- Page title -->
    <div class="page-header d-print-none">
        <div class="row align-items-center">
            <div class="col">
                <!-- Page pre-title -->
                <div class="page-pretitle">
                    Overview
                </div>
                <h2 class="page-title">
                    <?php echo $__env->yieldContent('title'); ?>
                </h2>
            </div>
            <!-- Page title actions -->
            <div class="col-auto ms-auto d-print-none">
                <div class="btn-list">
                    <a href="<?php echo e(route('admin.offer.index')); ?>" class="btn btn-primary d-none d-sm-inline-block">
                        <!-- Download SVG icon from http://tabler-icons.io/i/plus -->
                        <i class="fa fa-backward"></i>
                        Back
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="page-body">
    <div class="container-xl">
        <form action="<?php echo e(isset($offer) ? route('admin.offer.update', $offer->id) : route('admin.offer.store')); ?>"
            method="post" enctype="multipart/form-data" accept-charset="UTF-8">
            <?php echo csrf_field(); ?>
            <?php if(isset($offer)): ?>
                <?php echo method_field('PUT'); ?>
            <?php endif; ?>
            <div class="row row-cards">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Basic Info</h3>
                        </div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Advertiser</label>
                                <div>
                                    <select name="advertiser_id" class="form-select" id="advertiser_id"
                                        placeholder="  Select a advertiser..." required>
                                        <option selected disabled>Select Advertiser</option>
                                        <?php $__currentLoopData = $advertisers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $advertiser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if(isset($offer)): ?>
                                                <?php echo e($offer->advertiser_id == $advertiser->id ? 'selected' : ''); ?>

                                                <?php endif; ?>
                                                value="<?php echo e($advertiser->id); ?>"><?php echo e($advertiser->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Verticle</label>
                                <div>
                                    <select name="verticle_id" class="form-select" id="verticle_id"
                                        placeholder="  Select a Verticle..." required>
                                        <option selected disabled>Select Verticle</option>
                                        <?php $__currentLoopData = $verticles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $verticle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if(isset($offer)): ?>
                                                <?php echo e($offer->verticle_id == $verticle->id ? 'selected' : ''); ?>

                                                <?php endif; ?>
                                                value="<?php echo e($verticle->id); ?>"><?php echo e($verticle->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Category</label>
                                <div>
                                    <select name="category_id" class="form-select" id="category_id"
                                        placeholder="  Select a category..." required>
                                        <option selected disabled>Select Category</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if(isset($offer)): ?>
                                                <?php echo e($offer->category_id == $category->id ? 'selected' : ''); ?>

                                                <?php endif; ?>
                                                value="<?php echo e($category->id); ?>"><?php echo e($category->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Name</label>
                                <div>
                                    <input type="text" class="form-control" name="name"
                                        value="<?php echo e($offer->name ?? old('name')); ?>" placeholder="Name" required>
                                </div>
                                <?php $__errorArgs = ['first_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="error"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Description</label>
                                <div>
                                    <textarea id="summernote" class="form-control" name="description" rows="6" placeholder="Description" required><?php echo e($offer->description ?? old('description')); ?></textarea>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Preview Url</label>
                                <div>
                                    <input type="text" class="form-control" name="preview_link"
                                        value="<?php echo e($offer->preview_link ?? old('preview_link')); ?>"
                                        placeholder="Preview Url" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Traking Link with token</label>
                                <div>
                                    <input type="text" class="form-control" name="tracking_link"
                                        value="<?php echo e($offer->tracking_link ?? old('tracking_link')); ?>"
                                        placeholder="Traking Link with token" required>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Country</label>
                                <div>
                                    <select multiple name="country_id[]" class="form-select" id="country_id"
                                        placeholder="  Select a country...">
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if(isset($offer)): ?>
                                                <?php $__currentLoopData = $offer->countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($data->id == $country->id ? 'selected' : ''); ?>

                                                 <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
                                                value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Device</label>
                                <div>
                                    <select multiple name="device_id[]" class="form-select" id="device_id"
                                        placeholder="  Select a device...">
                                        <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option
                                                <?php if(isset($offer)): ?>
                                                    <?php $__currentLoopData = $offer->devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo e($data->id == $device->id ? 'selected' : ''); ?>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                                value="<?php echo e($device->id); ?>"><?php echo e($device->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>

                            <div class="form-group mb-3">
                                <label for="trafficAllowed" class="mb-2">Traffic Allowed</label>
                                <div class="d-flex flex-wrap gap-1">
                                    <?php if(isset($offer) && !empty($offer->traffic_allowed)): ?>
                                        <?php
                                            $traffic_allowed = explode(',', $offer->traffic_allowed);
                                        ?>
                                        <?php else: ?>
                                        <?php
                                            $traffic_allowed=[];
                                        ?>
                                    <?php endif; ?>

                                    <?php
                                        // Check for old input if the offer is not set
                                        $oldTrafficAllowed = old('traffic_allowed', []);
                                    ?>

                                    

                                    <!-- Checkbox 9 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Social Media', $traffic_allowed)) || in_array('Social Media', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Social Media"
                                            id="socialmedia">
                                        <label class="form-check-label" for="socialmedia">Email</label>
                                    </div>


                                    <!-- Checkbox 12 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Search PPC', $traffic_allowed)) || in_array('Search PPC', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Search PPC"
                                            id="ppc">
                                        <label class="form-check-label" for="ppc">Contextual</label>
                                    </div>

                                   
                                   
                                     <!--Checkbox 15 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('No Incent', $traffic_allowed)) || in_array('No Incent', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="No Incent"
                                            id="noincent">
                                        <label class="form-check-label" for="noincent">Display</label>
                                    </div>

                                   
                                   

                                    <!-- Checkbox 18 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Native', $traffic_allowed)) || in_array('Native', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Native"
                                            id="native">
                                        <label class="form-check-label" for="native">Search</label>
                                    </div>

                                     <!--Checkbox 19 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Mobile traffic', $traffic_allowed)) || in_array('Mobile traffic', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Mobile traffic"
                                            id="mobile-traffic">
                                        <label class="form-check-label" for="mobile-traffic">Social Media</label>
                                    </div>

                                    

                                    

                                    <!-- Checkbox 22 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Incent traffic', $traffic_allowed)) || in_array('Incent traffic', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Incent traffic"
                                            id="incent-traffic">
                                        <label class="form-check-label" for="incent-traffic">Native</label>
                                    </div>

                                   
                                    <!-- Checkbox 25 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Emailing', $traffic_allowed)) || in_array('Emailing', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Emailing"
                                            id="emailing">
                                        <label class="form-check-label" for="emailing">Mobile Ads</label>
                                    </div>

                                    <!-- Checkbox 26 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Doorways', $traffic_allowed)) || in_array('Doorways', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Doorways"
                                            id="doorways">
                                        <label class="form-check-label" for="doorways">Incentive</label>
                                    </div>

                                    <!-- Checkbox 27 -->
                                    <div class="form-check mr-3">
                                        <input class="form-check-input" type="checkbox" name="traffic_allowed[]"
                                            <?php if((isset($offer) && in_array('Context AD', $traffic_allowed)) || in_array('Context AD', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Context AD"
                                            id="context-ad">
                                        <label class="form-check-label" for="context-ad">Brand Bid</label>
                                    </div>

                                    

                                     <!--Checkbox 30 -->
                                    <!--<div class="form-check mr-3">-->
                                    <!--    <input class="form-check-input" type="checkbox" name="traffic_allowed[]"-->
                                    <!--        <?php if((isset($offer) && in_array('Banner Display', $traffic_allowed)) || in_array('Banner Display', $oldTrafficAllowed)): ?> checked <?php endif; ?> value="Banner Display"-->
                                    <!--        id="banner-display">-->
                                    <!--    <label class="form-check-label" for="banner-display">Banner Display</label>-->
                                    <!--</div>-->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Payouts & Cap</h3>
                        </div>
                        <div class="card-body">
                            <div class="form-group mb-3 ">
                                <label class="form-label">Type</label>
                                <div>
                                    <div class="input-icon">
                                        <select name="type" id="type" class="form-control">
                                            <option
                                                <?php if(isset($offer)): ?> <?php echo e($offer->type == 'offer'); ?> <?php endif; ?>
                                                value="offer">Fixed</option>
                                            <option
                                                <?php if(isset($offer)): ?> <?php echo e($offer->type == 'smartlink'); ?> <?php endif; ?>
                                                value="smartlink">Ratio</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Revenue</label>
                                <div>
                                    <input type="text" name="revenue" class="form-control" placeholder="Revenue"
                                        value="<?php echo e($offer->revenue ?? old('revenue')); ?>">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Payout</label>
                                <div>
                                    <input type="text" name="payout" class="form-control" placeholder="Payout"
                                        value="<?php echo e($offer->payout ?? old('payout')); ?>">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Conversion Status</label>
                                <div>
                                    <select name="conversion_status" id="conversion_status" class="form-control">
                                        <option
                                            <?php if(isset($offer)): ?> <?php echo e($offer->conversion_status == 1 ? 'selected' : ''); ?> <?php endif; ?>
                                            value="1">Approved</option>
                                        <option
                                            <?php if(isset($offer)): ?> <?php echo e($offer->conversion_status == 0 ? 'selected' : ''); ?> <?php endif; ?>
                                            value="0">Pending</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Alternative Offer</label>
                                <div>
                                    <select name="alt_offer_id" id="alt_offer_id" class="form-control">
                                        <option selected disabled>Select Alternative Offer</option>
                                        <?php $__currentLoopData = $alt_offers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $offers): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($offers->id); ?>"><?php echo e($offers->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Daily Cap</label>
                                <div>
                                    <input type="number" name="daily_cap" class="form-control"
                                        placeholder="Daily Cap" value="<?php echo e($offer->daily_cap ?? old('daily_cap')); ?>">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Expiration Date</label>
                                <div>
                                    <input type="date" name="expiration_date" class="form-control"
                                        placeholder="Expiration Date"
                                        value="<?php echo e($offer->expiration_date ?? old('expiration_date')); ?>">
                                </div>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Status</label>
                                <div>
                                    <select name="status" id="status" class="form-control">
                                        <option
                                            <?php if(isset($offer)): ?> <?php echo e($offer->status == 'active' ? 'selected' : ''); ?> <?php endif; ?>
                                            value="active">Active</option>
                                        <option
                                            <?php if(isset($offer)): ?> <?php echo e($offer->status == 'pending' ? 'selected' : ''); ?> <?php endif; ?>
                                            value="pending">Pending</option>
                                        <option
                                            <?php if(isset($offer)): ?> <?php echo e($offer->status == 'requestApproved' ? 'selected' : ''); ?> <?php endif; ?>
                                            value="requestApproved">Request Approved</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-check mb-3">
                                <input class="form-check-input" name="is_smart" value="1" type="checkbox"
                                    <?php if(isset($offer)): ?> <?php echo e($offer->is_smart == 1 ? 'checked' : ''); ?>

                                    <?php else: ?>
                                    <?php echo e(old('is_smart') == 1 ? 'checked' : ''); ?> <?php endif; ?>>
                                <label class="form-check-label" for="">
                                    Is this smart link
                                </label>
                            </div>

                            <div class="form-check mb-3">
                                <input class="form-check-input" name="top_offer" value="1" type="checkbox"
                                    <?php if(isset($offer)): ?> <?php echo e($offer->top_offer == 1 ? 'checked' : ''); ?>

                                    <?php else: ?>
                                    <?php echo e(old('top_offer') == 1 ? 'checked' : ''); ?> <?php endif; ?>>
                                <label class="form-check-label" for="">
                                    Is this top offer
                                </label>
                            </div>
                            <div class="form-group mb-3 ">
                                <label class="form-label">Avater</label>
                                <div>
                                    <input type="file" name="avater" class="form-control">
                                </div>
                            </div>
                            <div class="form-footer">
                                <button type="submit" class="btn btn-primary">
                                    <?php if(isset($offer)): ?>
                                        Update
                                    <?php else: ?>
                                        Create
                                    <?php endif; ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/summernote/summernote-lite.js')); ?>"></script>
<script>
    $('#summernote').summernote();
</script>
<script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.1/dist/js/tom-select.complete.min.js"></script>
<script>
    new TomSelect('#category_id', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#verticle_id', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#advertiser_id', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#country_id', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#device_id', {
        plugins: ['input_autogrow'],
    });
    new TomSelect('#manager_id', {
        plugins: ['input_autogrow'],
    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.admin_sash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/admin/offer/form.blade.php ENDPATH**/ ?>