<?php $__env->startSection('title', $offer->name); ?>

<?php $__env->startPush('css'); ?>
    <link href="<?php echo e(asset('public/backend/dist/css/tabler-flags.min.css')); ?>" rel="stylesheet" />
    <style>
        .card {
            border: none;
            box-shadow: 0 0.125rem 0.25rem rgba(0, 0, 0, 0.075);
            margin-bottom: 1.5rem;
        }

        .card-header {
            background-color: #f8f9fa;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
            font-weight: 600;
            padding: 1rem 1.25rem;
        }

        .card-body {
            padding: 1.5rem;
        }

        .payout-item {
            margin-bottom: 0.75rem;
            padding: 0.75rem;
            background: #f8f9fa;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }

        .application-note {
            background: #f8f9fa;
            border-radius: 0.5rem;
            padding: 1rem;
            font-size: 0.875rem;
            border-left: 3px solid #4e73df;
        }

        .badge {
            font-weight: 500;
            padding: 1em 0.65em;
        }

        .badge-soft-primary {
            background-color: rgba(78, 115, 223, 0.1);
            color: #4e73df;
        }

        .badge-soft-secondary {
            background-color: rgba(108, 117, 125, 0.1);
            color: #6c757d;
        }

        .badge-soft-success {
            background-color: rgba(40, 167, 69, 0.1);
            color: #28a745;
        }

        .badge-soft-danger {
            background-color: rgba(220, 53, 69, 0.1);
            color: #dc3545;
        }

        .badge-soft-warning {
            background-color: rgba(255, 193, 7, 0.1);
            color: #ffc107;
        }

        .badge-soft-info {
            background-color: rgba(23, 162, 184, 0.1);
            color: #17a2b8;
        }

        @media (max-width: 768px) {
            .card-body {
                padding: 1rem;
            }

            .payout-item {
                flex-direction: column;
                align-items: flex-start;
                gap: 0.5rem;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php
    $customCap = \App\CoustomCap::where('offer_id', $offer->id)
        ->where('user_id', Auth::id())
        ->first();
    $customPayout = \App\CoustomPayout::where('offer_id', $offer->id)
        ->where('user_id', Auth::id())
        ->first();
    $customCountryPayout = \App\CoustomCountryPayout::where('offer_id', $offer->id)
        ->where('user_id', Auth::id())
        ->get();
    $application = $offer->applications->where('user_id', Auth::id())->first();
    $offerBlocked = Auth::user()
        ->offers()
        ->where('offer_id', $offer->id)
        ->first();
    $isRequestAccess = $offer->status === 'requestApproved';
    $trackingDomain = rtrim(setting('tracking_domain'), '/');
    if (!Str::startsWith($trackingDomain, ['http://', 'https://'])) {
        $trackingDomain = 'https://' . $trackingDomain;
    }
    $trackingUrl = $trackingDomain . '/redirect?aff_id=' . Auth::id() . '&offer_id=' . $offer->id;
?>

<?php $__env->startSection('content'); ?>
    <div class="page-body">
        <div class="container-xl">
            <div class="row g-4">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-start flex-wrap gap-3 mb-4">
                                <div>
                                    <h1 class="h3 mb-1"><?php echo e($offer->name); ?></h1>
                                    <div class="text-muted">Offer ID: #<?php echo e($offer->id); ?></div>
                                </div>
                                <div class="d-flex gap-2 flex-wrap">
                                    <?php if($offerBlocked): ?>
                                        <span class="badge badge-soft-danger">
                                            <i class="fe fe-slash me-1"></i> Blocked
                                        </span>
                                    <?php elseif($isRequestAccess): ?>
                                        <?php if(is_null($application)): ?>
                                            <span class="badge badge-soft-warning">
                                                <i class="fe fe-lock me-1"></i> Request Access
                                            </span>
                                        <?php elseif($application->status === false): ?>
                                            <span class="badge badge-soft-warning">
                                                <i class="fe fe-clock me-1"></i> Pending Approval
                                            </span>
                                        <?php else: ?>
                                            <span class="badge badge-soft-success">
                                                <i class="fe fe-check-circle me-1"></i> Approved
                                            </span>
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <span class="badge badge-soft-success">
                                            <i class="fe fe-check-circle me-1"></i> Approved
                                        </span>
                                    <?php endif; ?>

                                    <span class="badge badge-soft-primary">
                                        <i class="fe fe-tag me-1"></i>
                                        <?php echo e($offer->type === 'offer' ? 'CPA Offer' : 'Revenue Share'); ?>

                                    </span>

                                    <?php if($offer->preview_link): ?>
                                        <a href="<?php echo e($offer->preview_link); ?>" target="_blank" class="btn btn-outline-primary btn-sm">
                                            <i class="fe fe-eye me-1"></i> Preview
                                        </a>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-8">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <i class="fe fe-info me-2"></i>Offer Details
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-4">
                                                <h6 class="fw-semibold mb-3">Description</h6>
                                                <div class="text-muted"><?php echo $offer->description; ?></div>
                                            </div>

                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <h6 class="fw-semibold mb-2">Expiration Date</h6>
                                                    <div class="text-muted">
                                                        <?php if($offer->expiration_date): ?>
                                                            <?php
                                                                try {
                                                                    echo \Carbon\Carbon::parse($offer->expiration_date)->format('M d, Y');
                                                                } catch (\Exception $e) {
                                                                    echo $offer->expiration_date;
                                                                }
                                                            ?>
                                                        <?php else: ?>
                                                            No expiration
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                    <h6 class="fw-semibold mb-2">Daily Cap</h6>
                                                    <div>
                                                        <?php if($customCap): ?>
                                                            <span class="badge badge-soft-success d-flex"><?php echo e($customCap->cap); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge badge-soft-success"><?php echo e($offer->daily_cap ?: 'Unlimited'); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="col-12">
                                                    <h6 class="fw-semibold mb-2">Payouts</h6>
                                                    <div class="payout-list">
                                                        <?php if($customCountryPayout->isNotEmpty()): ?>
                                                            <?php $__currentLoopData = $customCountryPayout; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($payout->devices && $payout->devices->isNotEmpty()): ?>
                                                                    <?php $__currentLoopData = $payout->devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <div class="payout-item">
                                                                            <div class="d-flex align-items-center gap-2">
                                                                                <span class="flag flag-country-<?php echo e(Str::lower(optional(optional($device->country)->country)->code)); ?>"></span>
                                                                                <span class="fw-medium"><?php echo e(optional($device->country->country)->name); ?></span>
                                                                                <span class="badge bg-light text-dark"><?php echo e($device->device->name); ?></span>
                                                                            </div>
                                                                            <span class="badge badge-soft-success">$<?php echo e(number_format($device->payout, 2)); ?></span>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php else: ?>
                                                                    <div class="payout-item">
                                                                        <div class="d-flex align-items-center gap-2">
                                                                            <span class="flag flag-country-<?php echo e(Str::lower(optional($payout->country)->code)); ?>"></span>
                                                                            <span class="fw-medium"><?php echo e(optional($payout->country)->name ?: 'Global'); ?></span>
                                                                        </div>
                                                                        <span class="badge badge-soft-success">$<?php echo e(number_format($payout->payout, 2)); ?></span>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php elseif($offer->countryPayouts->isNotEmpty()): ?>
                                                            <?php $__currentLoopData = $offer->countryPayouts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payout): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php if($payout->devices && $payout->devices->isNotEmpty()): ?>
                                                                    <?php $__currentLoopData = $payout->devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <div class="payout-item">
                                                                            <div class="d-flex align-items-center gap-2">
                                                                                <span class="flag flag-country-<?php echo e(Str::lower(optional(optional($device->countryPayout)->country)->code)); ?>"></span>
                                                                                <span class="fw-medium"><?php echo e(optional($device->countryPayout->country)->name); ?></span>
                                                                                <span class="badge bg-light text-dark"><?php echo e($device->device->name); ?></span>
                                                                            </div>
                                                                            <span class="badge badge-soft-success">$<?php echo e(number_format($device->payout, 2)); ?></span>
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php else: ?>
                                                                    <div class="payout-item">
                                                                        <div class="d-flex align-items-center gap-2">
                                                                            <span class="flag flag-country-<?php echo e(Str::lower(optional($payout->country)->code)); ?>"></span>
                                                                            <span class="fw-medium"><?php echo e(optional($payout->country)->name ?: 'Global'); ?></span>
                                                                        </div>
                                                                        <span class="badge badge-soft-success">$<?php echo e(number_format($payout->payout, 2)); ?></span>
                                                                    </div>
                                                                <?php endif; ?>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php elseif($customPayout): ?>
                                                            <div class="payout-item">
                                                                <span class="fw-medium">Default Payout</span>
                                                                <span class="badge badge-soft-success">$<?php echo e(number_format($customPayout->payout, 2)); ?></span>
                                                            </div>
                                                        <?php elseif($offer->type === 'offer'): ?>
                                                            <div class="payout-item">
                                                                <span class="fw-medium">Default Payout</span>
                                                                <span class="badge badge-soft-success">$<?php echo e(number_format($offer->payout, 2)); ?></span>
                                                            </div>
                                                        <?php else: ?>
                                                            <div class="payout-item">
                                                                <span class="fw-medium">Revenue Share</span>
                                                                <span class="badge badge-soft-info">Percentage Based</span>
                                                            </div>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php if(!$offerBlocked && (!$isRequestAccess || ($application && $application->status !== false))): ?>
                                        <div class="card">
                                            <div class="card-header">
                                                <i class="fe fe-link me-2"></i>Tracking Link
                                            </div>
                                            <div class="card-body">
                                                <div class="mb-3">
                                                    <label class="form-label">Your Tracking URL</label>
                                                    <div class="input-group">
                                                        <input type="text" class="form-control" id="trackingLink" value="<?php echo e($trackingUrl); ?>" data-base="<?php echo e($trackingUrl); ?>" readonly>
                                                        <button type="button" class="btn btn-primary" id="copyTrackingLink">
                                                            <i class="fe fe-copy me-1"></i> Copy
                                                        </button>
                                                    </div>
                                                    <div class="form-text small mt-1">Use this link to track your conversions</div>
                                                </div>

                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-3">Tracking Parameters</h6>
                                                    <div class="row g-3">
                                                        <div class="col-md-6">
                                                            <label for="aff_click_id" class="form-label">Click ID</label>
                                                            <input type="text" class="form-control" id="aff_click_id" data-tracking-param="aff_click_id" placeholder="e.g., campaign123">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="aff_sub_1" class="form-label">Sub ID 1</label>
                                                            <input type="text" class="form-control" id="aff_sub_1" data-tracking-param="aff_sub_1" placeholder="e.g., source">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="aff_sub_2" class="form-label">Sub ID 2</label>
                                                            <input type="text" class="form-control" id="aff_sub_2" data-tracking-param="aff_sub_2" placeholder="e.g., medium">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label for="aff_sub_3" class="form-label">Sub ID 3</label>
                                                            <input type="text" class="form-control" id="aff_sub_3" data-tracking-param="aff_sub_3" placeholder="e.g., campaign">
                                                        </div>
                                                        <div class="col-12">
                                                            <label class="form-label">Link Preview</label>
                                                            <div class="form-control bg-light text-truncate small" id="linkPreview"><?php echo e($trackingUrl); ?></div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>

                                <div class="col-md-4">
                                    <div class="card mb-4">
                                        <div class="card-header">
                                            <i class="fe fe-info me-2"></i>Offer Information
                                        </div>
                                        <div class="card-body">
                                            <div class="mb-3">
                                                <h6 class="fw-semibold mb-2">Category</h6>
                                                <span class="badge badge-soft-secondary"><?php echo e($offer->category->name); ?></span>
                                            </div>

                                            <?php if(optional($offer->verticle)?->name): ?>
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Vertical</h6>
                                                    <span class="badge badge-soft-info"><?php echo e($offer->verticle->name); ?></span>
                                                </div>
                                            <?php endif; ?>

                                            <?php if(isset($offer->countries) && $offer->countries->isNotEmpty()): ?>
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Target Countries</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <?php $__currentLoopData = $offer->countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <span class="badge d-flex align-items-center bg-light text-dark">
                                                                <?php if(isset($country->code)): ?>
                                                                    <span class="flag flag-country-<?php echo e(Str::lower($country->code)); ?> me-1"></span>
                                                                <?php endif; ?>
                                                                <?php echo e($country->name ?? 'N/A'); ?>

                                                            </span>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Target</h6>
                                                    <span class="badge badge-soft-success">Global Traffic</span>
                                                </div>
                                            <?php endif; ?>

                                            <?php if(isset($offer->devices) && $offer->devices->isNotEmpty()): ?>
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Devices</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <?php $__currentLoopData = $offer->devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(isset($device->name)): ?>
                                                                <span class="badge bg-light text-dark">
                                                                    <?php
                                                                        $deviceIcon = 'tablet';
                                                                        $deviceName = strtolower($device->name);
                                                                        if (str_contains($deviceName, 'mobile') || str_contains($deviceName, 'phone')) {
                                                                            $deviceIcon = 'smartphone';
                                                                        } elseif (str_contains($deviceName, 'desktop')) {
                                                                            $deviceIcon = 'monitor';
                                                                        }
                                                                    ?>
                                                                    <i class="fe fe-<?php echo e($deviceIcon); ?> me-1"></i>
                                                                    <?php echo e($device->name); ?>

                                                                </span>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <?php if(isset($offer->browsers) && $offer->browsers->isNotEmpty()): ?>
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Browsers</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <?php $__currentLoopData = $offer->browsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $browser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(isset($browser->name)): ?>
                                                                <span class="badge bg-light text-dark"><?php echo e($browser->name); ?></span>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>

                                            <?php if(isset($offer->operatingSystems) && $offer->operatingSystems->isNotEmpty()): ?>
                                                <div class="mb-3">
                                                    <h6 class="fw-semibold mb-2">Operating Systems</h6>
                                                    <div class="d-flex flex-wrap gap-2">
                                                        <?php $__currentLoopData = $offer->operatingSystems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $os): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if(isset($os->name)): ?>
                                                                <span class="badge bg-light text-dark"><?php echo e($os->name); ?></span>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                    </div>

                                    <?php if($offerBlocked): ?>
                                        <div class="card border-danger">
                                            <div class="card-header bg-danger text-white">
                                                <i class="fe fe-slash me-2"></i>Access Blocked
                                            </div>
                                            <div class="card-body">
                                                <p class="text-muted small mb-0">This offer is currently blocked for your account. Please contact support for assistance.</p>
                                            </div>
                                        </div>
                                    <?php elseif($isRequestAccess && is_null($application)): ?>
                                        <div class="card border-warning">
                                            <div class="card-header" style="background-color: rgba(255, 193, 7, 0.1);">
                                                <i class="fe fe-lock me-2"></i>Request Access
                                            </div>
                                            <div class="card-body">
                                                <p class="text-muted small mb-3">This offer requires approval. Please submit a request to promote this offer.</p>
                                                <form action="<?php echo e(route('affiliate.offer.request-access', $offer->id)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="mb-3">
                                                        <label for="message" class="form-label">Message (Optional)</label>
                                                        <textarea class="form-control" id="message" name="message" rows="3" placeholder="Tell us about your promotion methods..."></textarea>
                                                    </div>
                                                    <button type="submit" class="btn btn-warning w-100">
                                                        <i class="fe fe-send me-1"></i> Send Request
                                                    </button>
                                                </form>
                                            </div>
                                        </div>
                                    <?php elseif($isRequestAccess && $application && $application->status === false): ?>
                                        <div class="card border-warning">
                                            <div class="card-header" style="background-color: rgba(255, 193, 7, 0.1);">
                                                <i class="fe fe-clock me-2"></i>Request Pending
                                            </div>
                                            <div class="card-body">
                                                <p class="text-muted small mb-3">Your request to access this offer is pending approval. We'll notify you once it's been reviewed.</p>
                                                <?php if($application->message): ?>
                                                    <div class="application-note">
                                                        <strong>Your Message:</strong>
                                                        <p class="mb-0 mt-2"><?php echo e($application->message); ?></p>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const linkInput = document.getElementById('trackingLink');
            if (!linkInput) return;

            const baseUrl = linkInput.dataset.base;
            const paramsInputs = Array.from(document.querySelectorAll('[data-tracking-param]'));
            const linkPreview = document.getElementById('linkPreview');

            function rebuildLink() {
                try {
                    const url = new URL(baseUrl);

                    paramsInputs.forEach(function (input) {
                        const key = input.dataset.trackingParam;
                        const value = input.value.trim();
                        if (value) {
                            url.searchParams.set(key, value);
                        } else {
                            url.searchParams.delete(key);
                        }
                    });

                    const finalUrl = url.toString();
                    linkInput.value = finalUrl;

                    if (linkPreview) {
                        linkPreview.textContent = finalUrl.length > 80
                            ? finalUrl.substring(0, 80) + '...'
                            : finalUrl;
                        linkPreview.title = finalUrl;
                    }

                    return finalUrl;
                } catch (error) {
                    console.error('Unable to build tracking link', error);
                    return baseUrl;
                }
            }

            paramsInputs.forEach(function (input) {
                input.addEventListener('input', rebuildLink);
            });

            const copyBtn = document.getElementById('copyTrackingLink');
            if (copyBtn) {
                copyBtn.addEventListener('click', function () {
                    const finalUrl = rebuildLink();
                    navigator.clipboard.writeText(finalUrl)
                        .then(function () {
                            const originalText = copyBtn.innerHTML;
                            copyBtn.innerHTML = '<i class="fe fe-check me-1"></i>Copied!';
                            copyBtn.classList.remove('btn-primary');
                            copyBtn.classList.add('btn-success');

                            setTimeout(function () {
                                copyBtn.innerHTML = originalText;
                                copyBtn.classList.remove('btn-success');
                                copyBtn.classList.add('btn-primary');
                            }, 2000);
                        })
                        .catch(function (err) {
                            console.error('Could not copy text: ', err);
                            const alert = document.createElement('div');
                            alert.className = 'alert alert-danger mt-2 mb-0';
                            alert.role = 'alert';
                            alert.textContent = 'Failed to copy. Please copy the link manually.';
                            copyBtn.parentNode.parentNode.appendChild(alert);
                            setTimeout(() => alert.remove(), 3000);
                        });
                });
            }

            rebuildLink();
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.affiliate_sash', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/affiliate/offer/show.blade.php ENDPATH**/ ?>