<div class="card border rounded-3" id="chatCard" style="border-color: #e5e7eb !important;">
    <div class="card-header bg-white border-bottom d-flex justify-content-between align-items-center py-3 px-4" style="border-color: #e5e7eb !important;">
        <h6 class="card-title mb-0 fw-bold text-dark">
            <i class="fe fe-message-circle me-2" style="color: #6b7280;"></i>Live Chat
        </h6>
        <div class="d-flex align-items-center">
            <span class="badge border me-2 fw-semibold" id="chatStatus" style="background: #f9fafb; color: #6b7280; border-color: #e5e7eb;">
                <i class="fe fe-circle me-1" style="font-size: 0.5rem; color: #10b981;"></i>Online
            </span>
        </div>
    </div>
    <div class="card-body p-0" id="chatCardBody">
        
        <div class="d-flex bg-white" id="chatContainer" style="height: 450px; min-height: 400px;">
            
            <div class="bg-white border-end" id="chatSidebar" style="width: 280px; border-color: #e5e7eb !important;">
                <div class="bg-white border-bottom p-3" style="border-color: #e5e7eb !important;">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <button class="btn btn-outline-secondary btn-sm d-lg-none me-2" id="backToManagerBtn" style="border-color: #e5e7eb; color: #6b7280;">
                                <i class="fe fe-arrow-left"></i>
                            </button>
                            <h6 class="mb-0 fw-bold" style="color: #374151;">Conversations</h6>
                        </div>
                        <button class="btn btn-outline-secondary btn-sm" id="chatWithManagerBtn" title="Start new chat" style="border-color: #e5e7eb; color: #6b7280;">
                            <i class="fe fe-plus"></i>
                        </button>
                    </div>
                </div>
                
                <div class="p-2 overflow-auto" id="chatList" style="height: calc(100% - 70px);">
                </div>
            </div>
            
            <div class="flex-grow-1 d-flex flex-column position-relative">
                
                <button class="btn btn-outline-secondary btn-sm d-lg-none position-absolute" 
                        id="mobileChatToggle" style="top: 10px; left: 10px; z-index: 20; border-color: #e5e7eb; color: #6b7280; background: #f9fafb;">
                    <i class="fe fe-menu"></i>
                </button>
                
                <div id="noChatSelected" class="d-flex align-items-center justify-content-center h-100" style="color: #6b7280;">
                    <div class="text-center">
                        <div class="border rounded-circle d-flex align-items-center justify-content-center mx-auto mb-3" 
                             style="width: 60px; height: 60px; background: #f9fafb; border-color: #e5e7eb;">
                            <i class="fe fe-message-square fs-4" style="color: #6b7280;"></i>
                        </div>
                        <h6 class="mb-2" style="color: #374151;">Select a conversation</h6>
                        <p class="small mb-0" style="color: #6b7280;">Choose a chat from the sidebar to start messaging.</p>
                    </div>
                </div>
                
                <div id="chatArea" class="d-flex flex-column h-100">
                    
                    <div class="bg-white border-bottom p-3" style="border-color: #e5e7eb !important;">
                        <div class="d-flex align-items-center">
                            <button class="btn btn-outline-secondary btn-sm d-lg-none me-3" id="backToChatListBtn" style="border-color: #e5e7eb; color: #6b7280;">
                                <i class="fe fe-arrow-left"></i>
                            </button>
                            <div class="border rounded-circle d-flex align-items-center justify-content-center fw-semibold me-3" 
                                 style="width: 40px; height: 40px; font-size: 15px; background: #f9fafb; color: #6b7280; border-color: #e5e7eb;" id="chatAvatarContainer">
                                <span id="chatAvatar">U</span>
                            </div>
                            <div>
                                <h6 class="mb-0 fw-bold" id="chatTitle" style="color: #374151;">Chat Title</h6>
                                <div class="d-flex align-items-center">
                                    <span class="rounded-circle me-1" style="width: 8px; height: 8px; background: #10b981;"></span>
                                    <span class="small" id="chatStatusText" style="color: #6b7280;">Online</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="flex-grow-1 p-3 overflow-auto" id="chatMessages" style="padding-bottom: 20px;">
                    </div>
                    
                    <div class="bg-white border-top p-3" style="border-color: #e5e7eb !important;">
                        <div class="input-group">
                            <input type="text" class="form-control border" id="messageInput" placeholder="Type a message..." style="border-color: #e5e7eb; color: #374151;">
                            <button class="btn border" type="button" id="sendButton" style="background: #f9fafb; border-color: #e5e7eb; color: #6b7280;">
                                <i class="fe fe-send"></i>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="chatWithManagerModal" tabindex="-1">
    <div class="modal-dialog modal-sm modal-dialog-centered">
        <div class="modal-content border" style="border-color: #e5e7eb !important;">
            <div class="modal-header border-bottom pb-0" style="border-color: #e5e7eb !important;">
                <h5 class="modal-title fw-bold" style="color: #374151;">Start a New Chat</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body pt-2">
                <div class="text-center">
                    <div class="mb-3">
                        <i class="fe fe-user-check fs-1" style="color: #6b7280;"></i>
                    </div>
                    <p class="mb-3" style="color: #6b7280;">You can start a direct conversation with your Account Manager:</p>
                    <div id="managerInfoModal" class="p-3 border text-start small" style="background: #f9fafb; border-color: #e5e7eb;">
                        <p class="mb-0" style="color: #374151;"><strong>Manager:</strong> <span id="modalManagerName">John Wilson</span></p>
                        <p class="mb-0" style="color: #374151;"><strong>Role:</strong> <span id="modalManagerTitle">(Senior Account Manager)</span></p>
                    </div>
                </div>
            </div>
            <div class="modal-footer border-top pt-0" style="border-color: #e5e7eb !important;">
                <button type="button" class="btn btn-outline-secondary btn-sm" data-bs-dismiss="modal" style="border-color: #e5e7eb; color: #6b7280;">Cancel</button>
                <button type="button" class="btn btn-sm" id="startManagerChatBtn" style="background: #f9fafb; border-color: #e5e7eb; color: #374151;">Start Chat</button>
            </div>
        </div>
    </div>
</div>

<style>
/* Simplified Chat Design - Clean borders and white/gray colors */
.chat-item {
    padding: 12px 16px;
    margin-bottom: 2px;
    border: 1px solid #e5e7eb;
    border-radius: 4px;
    cursor: pointer;
    transition: all 0.2s ease;
    display: flex;
    align-items: center;
    gap: 12px;
    background: white;
}

.chat-item:hover {
    background: #f9fafb;
    border-color: #d1d5db;
}

.chat-item.active {
    background: #f3f4f6;
    border-color: #6b7280;
    color: #374151;
}

.chat-item.active .text-muted, .chat-item.active .fw-bold {
    color: #374151 !important;
}

.message {
    margin-bottom: 12px;
    display: flex;
    align-items: flex-start;
}

.message.sent {
    justify-content: flex-end;
}

.message-content {
    max-width: 80%;
    padding: 12px 16px;
    border: 1px solid #e5e7eb;
    border-radius: 8px;
    word-wrap: break-word;
    font-size: 14px;
    line-height: 1.4;
    position: relative;
    background: white;
}

.message.received .message-content {
    background: white;
    color: #374151;
    border-color: #e5e7eb;
}

.message.sent .message-content {
    background: #f9fafb;
    color: #374151;
    border-color: #d1d5db;
}

.message-time {
    font-size: 11px;
    color: #9ca3af;
    margin-top: 4px;
    text-align: right;
    display: block;
}

.message.sent .message-time {
    color: #6b7280;
}

.message.received .message-time {
    text-align: left;
    color: #6b7280;
}

/* Chat area display states */
#noChatSelected {
    display: flex !important;
}

#chatArea {
    display: none !important;
}

#chatArea.show {
    display: flex !important;
}

#noChatSelected.hide {
    display: none !important;
}

/* Mobile responsive styles */
@media (max-width: 768px) {
    #chatContainer {
        height: 400px !important;
        min-height: 350px !important;
        position: relative;
        border-radius: 4px;
        border: 1px solid #e5e7eb;
        overflow: hidden;
    }

    #chatSidebar {
        width: 280px;
        max-width: 85vw;
        position: absolute;
        height: 100%;
        transform: translateX(-100%);
        border: 1px solid #e5e7eb;
        background: white;
        z-index: 1100;
        transition: transform 0.3s ease-out;
        box-shadow: 2px 0 8px rgba(0, 0, 0, 0.1);
    }

    #chatSidebar.mobile-open {
        transform: translateX(0);
    }
    
    #chatMessages {
        padding-top: 60px !important;
        padding-bottom: 20px !important;
    }
    
    /* Ensure the chat card doesn't overflow on small screens */
    #chatCard {
        overflow: hidden;
    }
    
    /* Mobile toggle button styling */
    #mobileChatToggle {
        display: block !important;
        border-color: #e5e7eb;
        color: #6b7280;
        background: #f9fafb;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        z-index: 25 !important;
    }
    
    /* Hide desktop-only elements on mobile */
    .d-lg-none {
        display: block !important;
    }
    
    /* Ensure proper spacing for mobile */
    #chatArea {
        position: relative;
    }
    
    /* Mobile-specific button styling */
    #backToChatListBtn, #backToManagerBtn {
        display: block !important;
        border-color: #e5e7eb;
        color: #6b7280;
        background: #f9fafb;
    }
    
}

/* Tablet responsive styles */
@media (max-width: 992px) and (min-width: 769px) {
    #chatContainer {
        height: 400px !important;
    }
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    
    let currentChatId = null;
    
    // Test if we can find basic elements
    const chatCard = document.getElementById('chatCard');
    const chatMessages = document.getElementById('chatMessages');
    const messageInput = document.getElementById('messageInput');
    const chatList = document.getElementById('chatList');
    
    if (!chatMessages || !messageInput || !chatList) {
        return;
    }
    
    // Helper Functions
    function escapeHtml(text) {
        const div = document.createElement('div');
        div.textContent = text;
        return div.innerHTML;
    }
    
    function formatTime(dateString) {
        const date = new Date(dateString);
        return date.toLocaleTimeString([], { hour: '2-digit', minute: '2-digit' });
    }
    
    function scrollToBottom() {
        if (chatMessages) {
            // Use requestAnimationFrame for smoother scrolling
            requestAnimationFrame(() => {
                chatMessages.scrollTop = chatMessages.scrollHeight;
            });
        }
    }
    
    // Load chat data
    function loadChatData() {
        return fetch('<?php echo e(route("chat.data")); ?>')
        .then(response => {
            if (!response.ok) throw new Error('Network response was not ok.');
            return response.json();
        })
        .then(data => {
            if (data.success) {
                displayChats(data.chats);
                loadManagerInfo(data.users);
                return data;
            }
        })
        .catch(error => {
            throw error;
        });
    }
    
    // Load manager information
    function loadManagerInfo(users) {
        if (users.length > 0) {
            const manager = users[0];
            const fullName = `${manager.first_name} ${manager.last_name}`;
            const title = '(Senior Account Manager)';

            // Update MODAL manager display
            const modalManagerName = document.getElementById('modalManagerName');
            const modalManagerTitle = document.getElementById('modalManagerTitle');
            
            if (modalManagerName) modalManagerName.textContent = fullName;
            if (modalManagerTitle) modalManagerTitle.textContent = title;
            
            window.currentManagerId = manager.id;
        } else {
            window.currentManagerId = null;
        }
    }
    
    // Display chats in sidebar
    function displayChats(chats) {
        chatList.innerHTML = '';
        const currentUserId = <?php echo e(auth()->id() ?? 0); ?>;
        
        if (chats.length === 0) {
            chatList.innerHTML = '<div class="p-3 text-center text-muted">No conversations yet</div>';
            return;
        }
        
        chats.forEach(chat => {
            const chatItem = document.createElement('div');
            chatItem.className = 'chat-item';
            chatItem.dataset.chatId = chat.id;
            
            const otherParticipant = chat.participants.find(p => p.id !== currentUserId);
            const displayName = otherParticipant ? 
                `${otherParticipant.first_name} ${otherParticipant.last_name}` : 'Chat';
            const initials = displayName.charAt(0).toUpperCase();
            
            chatItem.innerHTML = `
                <div class="border rounded-circle d-flex align-items-center justify-content-center fw-semibold" 
                     style="width: 40px; height: 40px; font-size: 15px; background: #f9fafb; color: #6b7280; border-color: #e5e7eb;">${initials}</div>
                <div class="flex-grow-1">
                    <div class="fw-bold text-truncate small" style="color: #374151;">${displayName}</div>
                    ${chat.messages.length > 0 ? 
                        `<div class="text-truncate" style="font-size: 12px; color: #6b7280;">${escapeHtml(chat.messages[0].message.substring(0, 40))}...</div>` : 
                        '<div class="small" style="color: #6b7280;">No messages</div>'
                    }
                </div>
            `;
            
            chatList.appendChild(chatItem);
        });
        
        // Add click handlers for chat list
        chatList.addEventListener('click', function(e) {
            const chatItem = e.target.closest('.chat-item');
            if (chatItem) {
                const chatId = chatItem.dataset.chatId;
                selectChat(chatId);
            }
        });
    }
    
    function selectChat(chatId) {
        
        // Update active chat in sidebar
        document.querySelectorAll('.chat-item').forEach(item => {
            item.classList.remove('active');
        });
        
        const chatItem = document.querySelector(`[data-chat-id="${chatId}"]`);
        if (chatItem) {
            chatItem.classList.add('active');
            
            // Update chat header details
            const chatTitle = chatItem.querySelector('.fw-bold').textContent;
            const chatAvatarInitial = chatItem.querySelector('.border.rounded-circle').textContent;
            document.getElementById('chatTitle').textContent = chatTitle;
            document.getElementById('chatAvatar').textContent = chatAvatarInitial;
        }
        
        // Show chat area
        document.getElementById('noChatSelected').classList.add('hide');
        document.getElementById('chatArea').classList.add('show');
        
        // Hide sidebar on mobile when chat is selected
        if (window.innerWidth <= 768) {
            hideSidebar();
        }
        
        // Load chat messages
        loadChatMessages(chatId);
        
        currentChatId = chatId;
    }
    
    function loadChatMessages(chatId) {
        fetch(`<?php echo e(route("chat.messages", ":chatId")); ?>`.replace(':chatId', chatId))
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                displayMessages(data.messages);
            }
        })
        .catch(error => {
        });
    }
    
    function displayMessages(messages) {
        chatMessages.innerHTML = '';
        const currentUserId = <?php echo e(auth()->id() ?? 0); ?>;
        
        messages.forEach(message => {
            addMessageToChat(message, message.user_id === currentUserId);
        });
        
        // Scroll to bottom
        scrollToBottom();
    }
    
    function addMessageToChat(message, isSent) {
        
        const messageDiv = document.createElement('div');
        messageDiv.className = `message ${isSent ? 'sent' : 'received'}`;
        
        messageDiv.innerHTML = `
            <div class="message-content">
                ${escapeHtml(message.message)}
                <div class="message-time">${formatTime(message.created_at)}</div>
            </div>
        `;
        
        chatMessages.appendChild(messageDiv);
        
        // Scroll to bottom
        scrollToBottom();
    }
    
    // Event Listeners
    document.getElementById('chatWithManagerBtn').addEventListener('click', function() {
        if (!window.currentManagerId) {
             alert('No manager assigned to you');
             return;
        }
        const modal = new bootstrap.Modal(document.getElementById('chatWithManagerModal'));
        modal.show();
    });
    
    document.getElementById('startManagerChatBtn').addEventListener('click', function() {
        if (!window.currentManagerId) {
             alert('No manager assigned to you');
             return;
        }

        fetch('<?php echo e(route("chat.get-or-create")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({ user_id: window.currentManagerId })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const modal = bootstrap.Modal.getInstance(document.getElementById('chatWithManagerModal'));
                modal.hide();
                
                loadChatData().then(() => {
                    setTimeout(() => {
                        selectChat(data.chat.id);
                    }, 100);
                });
            } else {
                alert('Error: ' + (data.error || 'Failed to create chat'));
            }
        });
    });

    // Send message handlers
    document.getElementById('sendButton').addEventListener('click', sendMessage);
    document.getElementById('messageInput').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            sendMessage();
        }
    });
    
    function sendMessage() {
        const message = messageInput.value.trim();
        
        if (!message || !currentChatId) return;
        
        fetch('<?php echo e(route("chat.send-message")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                chat_id: currentChatId,
                message: message
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                messageInput.value = '';
                addMessageToChat(data.message, true);
            } else {
                alert('Error: ' + (data.error || 'Failed to send message'));
            }
        })
        .catch(error => {
            alert('Failed to send message: ' + error.message);
        });
    }

    // Mobile Sidebar Toggle Functionality
    const chatSidebar = document.getElementById('chatSidebar');
    const mobileChatToggle = document.getElementById('mobileChatToggle');
    const backToChatListBtn = document.getElementById('backToChatListBtn');
    const backToManagerBtn = document.getElementById('backToManagerBtn');
    
    // Toggle sidebar visibility
    function toggleSidebar() {
        if (chatSidebar) {
            chatSidebar.classList.toggle('mobile-open');
        }
    }
    
    // Hide sidebar
    function hideSidebar() {
        if (chatSidebar) {
            chatSidebar.classList.remove('mobile-open');
        }
    }
    
    // Show sidebar
    function showSidebar() {
        if (chatSidebar) {
            chatSidebar.classList.add('mobile-open');
        }
    }
    
    // Mobile toggle button - show sidebar
    if (mobileChatToggle) {
        mobileChatToggle.addEventListener('click', function() {
            showSidebar();
        });
    }
    
    // Back to chat list button - hide sidebar when in chat view
    if (backToChatListBtn) {
        backToChatListBtn.addEventListener('click', function() {
            hideSidebar();
        });
    }
    
    // Back to manager button - hide sidebar when in manager view
    if (backToManagerBtn) {
        backToManagerBtn.addEventListener('click', function() {
            hideSidebar();
        });
    }
    
    // Close sidebar when clicking outside on mobile
    document.addEventListener('click', function(e) {
        if (window.innerWidth <= 768) {
            const isClickInsideSidebar = chatSidebar && chatSidebar.contains(e.target);
            const isClickOnToggle = mobileChatToggle && mobileChatToggle.contains(e.target);
            
            if (!isClickInsideSidebar && !isClickOnToggle) {
                if (chatSidebar && chatSidebar.classList.contains('mobile-open')) {
                    hideSidebar();
                }
            }
        }
    });
    
    // Handle window resize
    window.addEventListener('resize', function() {
        if (window.innerWidth > 768) {
            // On desktop, ensure sidebar is always visible
            if (chatSidebar) {
                chatSidebar.classList.remove('mobile-open');
            }
        }
    });
    
    // Make functions globally accessible for other components
    window.toggleChatSidebar = toggleSidebar;
    window.showChatSidebar = showSidebar;
    window.hideChatSidebar = hideSidebar;
    window.selectChatInUI = selectChat;

    // Initialize
    loadChatData().then(() => {
    }).catch(error => {
    });
});
</script>
<?php /**PATH C:\xampp\htdocs\resources\views/components/chat-ui.blade.php ENDPATH**/ ?>